<?php
/* --------------------------------------------------------------
   KlarnaHubPdfOrderExtender.inc.php 2017-11-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2017 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class KlarnaHubPdfOrderExtender extends KlarnaHubPdfOrderExtender_parent
{
    public function extendOrderInfo($orderInfo)
    {
        $orderInfo = parent::extendOrderInfo($orderInfo);
        if($_GET['type'] === 'invoice')
        {
            $orderService = StaticGXCoreLoader::getService('OrderRead');
            $order = $orderService->getOrderById(new IdType((int)$_GET['oID']));
            $paymentType = $order->getPaymentType();
            $paymentModule = $paymentType->getModule();
    
            if(in_array($paymentModule, ['KlarnaPaylaterHub', 'KlarnaPaynowHub', 'KlarnaSliceitHub', 'KlarnaBanktransferHub'], true))
            {
                $languageId = $this->v_data_array['order']->info['languages_id'];
                $language = MainFactory::create('LanguageTextManager', 'gambio_hub_klarna_hub', $languageId);
                $orderInfo['KlarnaHub'] = [
                    0 => 'Klarna',
                    1 => $language->get_text('InvoiceNote'),
                ];
        
            }
        }
        return $orderInfo;
    }
    
    public function extendPdfFooter($footer)
    {
        $footer = parent::extendPdfFooter($footer);
    
        if($_GET['type'] === 'invoice')
        {
            $orderService  = StaticGXCoreLoader::getService('OrderRead');
            $order         = $orderService->getOrderById(new IdType((int)$_GET['oID']));
            $paymentType   = $order->getPaymentType();
            $paymentModule = $paymentType->getModule();
    
            if (in_array($paymentModule, ['KlarnaPaylaterHub', 'KlarnaPaynowHub', 'KlarnaSliceitHub', 'KlarnaBanktransferHub'], true)) {
                $replaceFooterColumn = gm_get_conf('PDF_FOOTER_REPLACE_COLUMN');
                if ('null' === $replaceFooterColumn || empty($replaceFooterColumn)) {
                    return $footer;
                }
                if (array_key_exists($replaceFooterColumn, $footer)) {
                    unset($footer[$replaceFooterColumn]);
                    $footer = array_values($footer);
                }
            }
        }
        
        return $footer;
    }

}
